(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     20554,        514]*)
(*NotebookOutlinePosition[     21206,        537]*)
(*  CellTagsIndexPosition[     21162,        533]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(f[x_] = \((6 - 2  x)\)/3\)], "Input"],

Cell[BoxData[
    \(1\/3\ \((6 - 2\ x)\)\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[
      Graphics[{Line[{{0, 2}, {3, 0}}], 
          Line[{{1.6, 0}, {1.6, f[1.6]}, {0, f[1.6]}}], 
          Circle[{3, 0}, 0.4, {Pi - ArcTan[2/3], Pi}], 
          Circle[{1.6, f[1.6]}, 
            0.4, {Pi - ArcTan[2/3], Pi}], \[IndentingNewLine]Text[
            a1, {1.8, f[1.6]}], Text[a2, {1.6, \(-0.15\)}], 
          Text[a3, {\(-0.15\), f[1.6]}], Text[a4, {2.35, 0.17}], 
          Text[a5, {1, f[1.6] + 0.15}], Text[a6, {0.15, 2.1}], 
          Text[a7, {2.7, \(-0.2\)}]}, Axes \[Rule] True, \ 
        AxesStyle \[Rule] {Thickness[0.003]}, Ticks \[Rule] None, 
        PlotRange \[Rule] {{\(-0.2\), 3.5}, {\(-0.2\), 2.5}}, 
        AspectRatio \[Rule] Automatic]]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .72973 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0540541 0.27027 0.0540541 0.27027 [
[ -0.0015 -0.0015 0 0 ]
[ 1.0015 .73123 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.003 w
[ ] 0 setdash
0 .05405 m
1 .05405 L
s
.05405 0 m
.05405 .72973 L
s
0 0 m
1 0 L
1 .72973 L
0 .72973 L
closepath
clip
newpath
.5 Mabswid
.05405 .59459 m
.86486 .05405 L
s
.48649 .05405 m
.48649 .30631 L
.05405 .30631 L
s
newpath
.86486 .05405 .10811 146.31 180 arc
s
newpath
.48649 .30631 .10811 146.31 180 arc
s
gsave
.54054 .30631 -69 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a1) show
1.000 setlinewidth
grestore
gsave
.48649 .01351 -69 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a2) show
1.000 setlinewidth
grestore
gsave
.01351 .30631 -69 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a3) show
1.000 setlinewidth
grestore
gsave
.68919 .1 -69 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a4) show
1.000 setlinewidth
grestore
gsave
.32432 .34685 -69 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a5) show
1.000 setlinewidth
grestore
gsave
.09459 .62162 -69 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a6) show
1.000 setlinewidth
grestore
gsave
.78378 0 -69 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding ISOLatin1Encoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0 20.5625 translate 1 -1 scale
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(a7) show
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 210.125},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000dQP00`40o`000?l0003ofoooo`@00004
oooo00<0003oooooool0>_ooo`004?ooo`030000oooooooo0<_oool00`000?ooooooo`02oooo00<0
003oooooool0>_ooo`004?ooo`030000oooooooo0<Woool300001Oooo`030000oooooooo03Woool0
013oool00`000?ooooooo`1coooo1@000003oooo000000000080001Aoooo00@0003oooooool0000k
oooo000@oooo00<0003oooooool0Loooo`@00002oooo00<0003oooooool0D_ooo`@0000koooo000@
oooo00<0003oooooool0M_ooo`050000oooooooooooo000009;oool0013oool00`000?ooooooo`1d
oooo0`0000Coool00`000?ooooooo`2?oooo000@oooo00<0003oooooool0NOooo`040000oooooooo
0000T?ooo`004?ooo`030000oooooooo07[oool20000TOooo`004?ooo`030000oooooooo0?ooool>
oooo000@oooo00<0003oooooool0ooooo`koool0013oool00`000?ooooooo`3ooooo3_ooo`004?oo
o`030000oooooooo0?ooool>oooo000@oooo00<0003oooooool0ooooo`koool0013oool00`000?oo
ooooo`3ooooo3_ooo`004?ooo`030000oooooooo0?ooool>oooo003o00008000007oool0013oool0
0`000?ooooooo`1hoooo00<0003oooooool0B_ooo`030000oooooooo01[oool20000:Oooo`004?oo
o`030000oooooooo07Soool00`000?ooooooo`1:oooo00<0003oooooool06Oooo`030000oooooooo
02Woool0013oool00`000?ooooooo`1hoooo00<0003oooooool0B_ooo`030000oooooooo01Ooool2
0000;?ooo`004?ooo`030000oooooooo07Soool00`000?ooooooo`1;oooo00<0003oooooool05Ooo
o`030000oooooooo02coool0013oool00`000?ooooooo`1hoooo00<0003oooooool0Boooo`030000
oooooooo01?oool20000;oooo`004?ooo`030000oooooooo07Soool00`000?ooooooo`1;oooo00<0
003oooooool04_ooo`030000oooooooo02ooool0013oool00`000?ooooooo`1hoooo00<0003ooooo
ool0Boooo`030000oooooooo013oool20000<_ooo`004?ooo`030000oooooooo07Soool00`000?oo
ooooo`1<oooo00<0003oooooool03_ooo`030000oooooooo03;oool0013oool00`000?ooooooo`1h
oooo00<0003oooooool0C?ooo`030000oooooooo00coool20000=Oooo`004?ooo`030000oooooooo
07Soool00`000?ooooooo`1<oooo00<0003oooooool02oooo`030000oooooooo03Goool0013oool0
0`000?ooooooo`1hoooo00<0003oooooool0C?ooo`030000oooooooo00Woool20000>?ooo`004?oo
o`030000oooooooo07Soool00`000?ooooooo`0boooo1@0000?oool300004?ooo`030000oooooooo
00Ooool00`000?ooooooo`0hoooo000@oooo00<0003oooooool0N?ooo`030000oooooooo03;oool4
00001Oooo`030000oooooooo00ooool00`000?ooooooo`05oooo0P0003_oool0013oool00`000?oo
ooooo`1hoooo00<0003oooooool0=Oooo`030000oooooooo00D0000Aoooo00<0003oooooool00ooo
o`030000oooooooo03_oool0013oool00`000?ooooooo`1hoooo00<0003oooooool0<oooo`<00002
oooo00@0003oooooool0000Boooo00@0003oooooooooool20000?_ooo`004?ooo`030000oooooooo
07Soool00`000?ooooooo`0ioooo00<0003oool000004oooo`030000oooo0000043oool0013oool0
0`000?ooooooo`1hoooo00<0003oooooool0>_ooo`80000Coooo0P00047oool0013oool00`000?oo
ooooo`1hoooo00<0003oooooool0C_ooo`030000oooooooo047oool0013oool00`000?ooooooo`1h
oooo00<0003oooooool0C?ooo`800014oooo000@oooo00<0003oooooool0N?ooo`030000oooooooo
04_oool00`000?ooooooo`14oooo000@oooo00<0003oooooool0N?ooo`030000oooooooo04Woool2
0000Aoooo`004?ooo`030000oooooooo07Soool00`000?ooooooo`18oooo00<0003oooooool0Aooo
o`004?ooo`030000oooooooo07Soool00`000?ooooooo`16oooo0P0004[oool0013oool00`000?oo
ooooo`1hoooo00<0003oooooool0AOooo`030000oooooooo04[oool0013oool00`000?ooooooo`1h
oooo00<0003oooooool0@oooo`80001=oooo000@oooo00<0003oooooool0N?ooo`030000oooooooo
04;oool00`000?ooooooo`1=oooo000@oooo00<0003oooooool0N?ooo`030000oooooooo043oool2
0000D?ooo`004?ooo`030000oooooooo07Soool00`000?ooooooo`0ooooo00<0003oooooool0D?oo
o`004?ooo`030000oooooooo07Soool00`000?ooooooo`0moooo0P0005?oool0013oool00`000?oo
ooooo`1hoooo00<0003oooooool0??ooo`030000oooooooo05?oool0013oool00`000?ooooooo`1h
oooo00<0003oooooool0>_ooo`80001Foooo000@oooo00<0003oooooool0N?ooo`030000oooooooo
03Woool00`000?ooooooo`1Foooo000@oooo00<0003oooooool0N?ooo`030000oooooooo03Ooool2
0000FOooo`004?ooo`030000oooooooo07Soool00`000?ooooooo`0foooo00<0003oooooool0FOoo
o`004?ooo`030000oooooooo07Soool00`000?ooooooo`0doooo0P0005coool0013oool00`000?oo
ooooo`1hoooo00<0003oooooool0<oooo`030000oooooooo05coool0013oool00`000?ooooooo`1h
oooo00<0003oooooool0<Oooo`80001Ooooo000@oooo00<0003oooooool0N?ooo`030000oooooooo
033oool00`000?ooooooo`1Ooooo000@oooo00<0003oooooool0N?ooo`030000oooooooo02koool2
0000H_ooo`004?ooo`030000oooooooo07Soool00`000?ooooooo`0]oooo00<0003oooooool0H_oo
o`004?ooo`030000oooooooo07Soool00`000?ooooooo`0[oooo0P0006Goool0013oool00`000?oo
ooooo`1hoooo00<0003oooooool0:_ooo`030000oooooooo06Goool0013oool00`000?ooooooo`1h
oooo00<0003oooooool0:?ooo`80001Xoooo000@oooo00<0003oooooool0N?ooo`030000oooooooo
02Ooool00`000?ooooooo`1Xoooo000@oooo00<0003oooooool0N?ooo`030000oooooooo02Goool2
0000Joooo`004?ooo`030000oooooooo07Soool00`000?ooooooo`0Toooo00<0003oooooool0Jooo
o`004?ooo`030000oooooooo07Soool00`000?ooooooo`0Roooo0P0006koool0013oool00`000?oo
ooooo`1hoooo00<0003oooooool08Oooo`030000oooooooo06koool0013oool00`000?ooooooo`1h
oooo00<0003oooooool07oooo`80001aoooo000@oooo00<0003oooooool0N?ooo`030000oooooooo
01koool00`000?ooooooo`1aoooo000@oooo00<0003oooooool0N?ooo`030000oooooooo01coool2
0000M?ooo`004?ooo`030000oooooooo07Soool00`000?ooooooo`0Koooo00<0003oooooool0M?oo
o`004?ooo`030000oooooooo07Soool00`000?ooooooo`0Ioooo0P0007Ooool0013oool00`000?oo
ooooo`1hoooo00<0003oooooool06?ooo`030000oooooooo07Ooool0013oool00`000?ooooooo`1h
oooo00<0003oooooool05_ooo`80001joooo000@oooo00<0003oooooool0N?ooo`030000oooooooo
01Goool00`000?ooooooo`1joooo000@oooo00<0003oooooool0N?ooo`030000oooooooo01?oool2
0000OOooo`004?ooo`030000oooooooo07Soool00`000?ooooooo`0Boooo00<0003oooooool0OOoo
o`004?ooo`030000oooooooo07Soool00`000?ooooooo`0@oooo0P00083oool0013oool00`000?oo
ooooo`1hoooo00<0003oooooool03oooo`030000oooooooo083oool0013oool00`000?ooooooo`1h
oooo00<0003oooooool03Oooo`800023oooo000@oooo00<0003oooooool0N?ooo`030000oooooooo
00coool00`000?ooooooo`23oooo000@oooo00<0003oooooool0N?ooo`030000oooooooo00[oool2
0000Q_ooo`004?ooo`030000oooooooo07Soool00`000?ooooooo`09oooo00<0003oooooool0Q_oo
o`004?ooo`030000oooooooo07Soool00`000?ooooooo`07oooo0P0008Woool0013oool00`000?oo
ooooo`1hoooo00<0003oooooool01_ooo`030000oooooooo08Woool0013oool00`000?ooooooo`1h
oooo00<0003oooooool01?ooo`80002<oooo000@oooo00<0003oooooool0N?ooo`030000oooooooo
00?oool00`000?ooooooo`2<oooo000@oooo00<0003oooooool0N?ooo`040000oooooooooooo0P00
08ooool0013oool00`000?ooooooo`1hoooo00@0003oooooool0002Aoooo000400000_ooo`800008
oooo00<0003oooooool0N?ooo`<00008oooo1@000003oooo0000000000<0001ooooo000300000_oo
o`040000oooooooo00001oooog`0000:oooo100000Coool00`000?ooooooo`1ooooo0002oooo00<0
003oooooool00_ooo`030000oooooooo00Koool00`000?ooooooo`1Ioooo00<0003oooooool06_oo
o`80000>oooo00<0003oooooool00_ooo`030000oooooooo07ooool000<00005oooo00<0003ooooo
ool01Oooo`030000oooooooo05Woool00`000?ooooooo`0Ioooo00<0003oooooool03?ooo`<00004
oooo00<0003oooooool0Ooooo`001Oooo`040000oooooooo00001oooo`030000oooooooo05Woool0
0`000?ooooooo`0Goooo0P0001Koool00`000?ooooooo`1ooooo0006oooo0P0000Soool00`000?oo
ooooo`1Joooo00<0003oooooool05Oooo`030000oooooooo01Goool20000POooo`004?ooo`030000
oooooooo05[oool00`000?ooooooo`0Coooo0P0009_oool0013oool00`000?ooooooo`1Joooo00<0
003oooooool04_ooo`030000oooooooo09_oool0013oool00`000?ooooooo`1Joooo00<0003ooooo
ool04?ooo`80002Noooo000@oooo00<0003oooooool0Foooo`030000oooooooo00koool00`000?oo
ooooo`2Noooo000@oooo00<0003oooooool0Foooo`030000oooooooo00coool20000XOooo`004?oo
o`030000oooooooo04Goool500000_ooo`80000=oooo00<0003oooooool02oooo`030000oooooooo
0:7oool0013oool00`000?ooooooo`15oooo100000;oool010000?ooooooo`0000coool00`000?oo
ooooo`09oooo0P000:Coool0013oool00`000?ooooooo`18oooo00<0003oooooool00oooo`030000
oooooooo00_oool00`000?ooooooo`07oooo00<0003oooooool0Y?ooo`004?ooo`030000oooooooo
04Koool300000oooo`80000>oooo00<0003oooooool01Oooo`80002Woooo000@oooo00<0003ooooo
ool0C?ooo`030000oooooooo00koool00`000?ooooooo`03oooo00<0003oooooool0Yoooo`004?oo
o`030000oooooooo04coool300003_ooo`040000oooooooooooo0P000:[oool0013oool00`000?oo
ooooo`1Noooo00<0003oool00000[?ooo`004?ooo`030000oooooooo05koool20000[Oooo`004?oo
o`030000oooooooo05goool00`000?ooooooo`2]oooo000@oooo00<0003oooooool0Foooo`80002`
oooo000@oooo00<0003oooooool0F_ooo`030000oooooooo0;3oool0013oool00`000?ooooooo`1H
oooo0P000;?oool0013oool00`000?ooooooo`1Goooo00<0003oooooool0/oooo`004?ooo`030000
oooooooo05Goool20000]_ooo`004?ooo`030000oooooooo05Coool00`000?ooooooo`2foooo000@
oooo00<0003oooooool0D_ooo`80002ioooo000@oooo00<0003oooooool0DOooo`030000oooooooo
0;Woool0013oool00`000?ooooooo`1?oooo0P000;coool0013oool00`000?ooooooo`1>oooo00<0
003oooooool0_?ooo`004?ooo`030000oooooooo04coool20000_oooo`004?ooo`030000oooooooo
04_oool00`000?ooooooo`2ooooo000@oooo00<0003oooooool0BOooo`800032oooo000@oooo00<0
003oooooool0B?ooo`030000oooooooo0<;oool0013oool00`000?ooooooo`16oooo0P000<Goool0
013oool00`000?ooooooo`15oooo00<0003oooooool0aOooo`004?ooo`030000oooooooo04?oool2
0000b?ooo`004?ooo`030000oooooooo04;oool00`000?ooooooo`38oooo000@oooo00<0003ooooo
ool0@?ooo`80003;oooo000@oooo00<0003oooooool0?oooo`030000oooooooo0<_oool0013oool0
0`000?ooooooo`0moooo0P000<koool0013oool00`000?ooooooo`0loooo00<0003oooooool0c_oo
o`004?ooo`030000oooooooo03[oool20000dOooo`004?ooo`030000oooooooo03Woool00`000?oo
ooooo`3Aoooo000@oooo00<0003oooooool0=oooo`80003Doooo000@oooo00<0003oooooool0=_oo
o`030000oooooooo0=Coool0013oool00`000?ooooooo`0doooo0P000=Ooool0013oool00`000?oo
ooooo`0coooo00<0003oooooool0eoooo`004?ooo`030000oooooooo037oool20000f_ooo`004?oo
o`030000oooooooo033oool00`000?ooooooo`3Joooo000@oooo00<0003oooooool0;_ooo`80003M
oooo000@oooo00<0003oooooool0;Oooo`030000oooooooo0=goool0013oool00`000?ooooooo`0[
oooo0P000>3oool0013oool00`000?ooooooo`0Zoooo00<0003oooooool0h?ooo`004?ooo`030000
oooooooo02Soool20000hoooo`004?ooo`030000oooooooo02Ooool00`000?ooooooo`3Soooo000@
oooo00<0003oooooool09Oooo`80003Voooo000@oooo00<0003oooooool09?ooo`030000oooooooo
0>Koool0013oool00`000?ooooooo`0Roooo0P000>Woool0013oool00`000?ooooooo`0Qoooo00<0
003oooooool0jOooo`004?ooo`030000oooooooo01ooool20000k?ooo`004?ooo`030000oooooooo
01koool00`000?ooooooo`3/oooo000@oooo00<0003oooooool07?ooo`80003_oooo000@oooo00<0
003oooooool06oooo`030000oooooooo0>ooool0013oool00`000?ooooooo`0Ioooo0P000?;oool0
013oool00`000?ooooooo`0Hoooo00<0003oooooool0l_ooo`004?ooo`030000oooooooo01Koool2
0000mOooo`004?ooo`030000oooooooo01Goool00`000?ooooooo`3eoooo000@oooo00<0003ooooo
ool04oooo`80003hoooo000@oooo00<0003oooooool04_ooo`030000oooooooo0?Soool0013oool0
0`000?ooooooo`0@oooo0P000?_oool0013oool00`000?ooooooo`0?oooo00<0003oooooool0nooo
o`004?ooo`030000oooooooo00goool20000o_ooo`004?ooo`030000oooooooo00coool00`000?oo
ooooo`3noooo000@oooo00<0003oooooool02_ooo`80003ooooo0_ooo`004?ooo`030000oooooooo
00Woool00`000?ooooooo`3ooooo0_ooo`004?ooo`030000oooooooo00Ooool20000ooooo`Goool0
013oool00`000?ooooooo`06oooo00<0003oooooool0ooooo`Goool0013oool00`000?ooooooo`04
oooo0P000?ooool8oooo000@oooo00<0003oooooool00oooo`030000oooooooo0?ooool8oooo000@
oooo00@0003oooooooooool20000ooooo`_oool0013oool010000?ooooooo`000?ooool=oooo000@
oooo0`000?ooool>oooo000@oooo00<0003oooooool0ooooo`koool0013oool00`000?ooooooo`3o
oooo3_ooo`004?ooo`030000oooooooo0?ooool>oooo000@oooo00<0003oooooool0ooooo`koool0
013oool00`000?ooooooo`3ooooo3_ooo`004?ooo`030000oooooooo0?ooool>oooo000@oooo00<0
003oooooool0ooooo`koool0013oool00`000?ooooooo`03oooo1@000004oooo000000000000oooo
o`;oool0013oool00`000?ooooooo`03oooo100000;oool010000?ooooooo`000?ooool1oooo000@
oooo00<0003oooooool01_ooo`040000oooooooo00000_ooo`030000oooooooo0?koool0013oool0
0`000?ooooooo`04oooo0`0000;oool30000ooooo`;oool0013oool00`000?ooooooo`0:oooo00<0
003oooooool0ooooo`7oool0013oool00`000?ooooooo`0:oooo0`000?ooool1oooo000@oooo00<0
003oooooool0ooooo`koool0013oool00`000?ooooooo`3ooooo3_ooo`004?ooo`030000oooooooo
0?ooool>oooo000@oooo00<0003oooooool0ooooo`koool0013oool00`000?ooooooo`3ooooo3_oo
o`004?ooo`030000oooooooo0?ooool>oooo000@oooo00<0003oooooool0ooooo`koool0013oool0
0`000?ooooooo`3ooooo3_ooo`004?ooo`030000oooooooo0?ooool>oooo000@oooo00<0003ooooo
ool0ooooo`koool0013oool00`000?ooooooo`3ooooo3_ooo`004?ooo`030000oooooooo0?ooool>
oooo000@oooo00<0003oooooool0ooooo`koool0013oool00`000?ooooooo`3ooooo3_ooo`004?oo
o`030000oooooooo0?ooool>oooo000@oooo00<0003oooooool0ooooo`koool0013oool00`000?oo
ooooo`3ooooo3_ooo`004?ooo`030000oooooooo0?ooool>oooo000@oooo00<0003oooooool0oooo
o`koool0013oool00`000?ooooooo`3ooooo3_ooo`004?ooo`030000oooooooo0?ooool>oooo000@
oooo00<0003oooooool0ooooo`koool0013oool00`000?ooooooo`3ooooo3_ooo`004?ooo`030000
oooooooo0?ooool>oooo000@oooo00<0003oooooool0ooooo`koool0013oool00`000?ooooooo`3o
oooo3_ooo`004?ooo`030000oooooooo0?ooool>oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {209.125, 0}} -> {-0.210356, -0.205564, \
0.0129642, 0.0129642}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Display["\<escala.eps\>", \ %, \ "\<EPS\>"]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
WindowSize->{792, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 57, 1, 30, "Input"],
Cell[1799, 54, 54, 1, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1890, 60, 713, 13, 130, "Input"],
Cell[2606, 75, 17553, 420, 219, 5111, 262, "GraphicsData", "PostScript", \
"Graphics"],
Cell[20162, 497, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[20329, 505, 76, 1, 30, "Input"],
Cell[20408, 508, 130, 3, 29, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

